<?php
// save.php — simpan data editor ke results.json (gunakan token sederhana)

header('Content-Type: text/plain; charset=utf-8');

// ===== KONFIG =====
$SECRET_TOKEN = 'YOUR_SECRET_TOKEN'; // GANTI & samakan dengan editor.html
$RESULTS_FILE = __DIR__ . '/results.json';

// Method check
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  http_response_code(405);
  echo "Method not allowed";
  exit;
}

// Token check
$token = $_POST['token'] ?? '';
if (!hash_equals($SECRET_TOKEN, $token)) {
  http_response_code(401);
  echo "Unauthorized";
  exit;
}

// Payload check
$payload = $_POST['payload'] ?? '';
if (!$payload) {
  http_response_code(400);
  echo "Missing payload";
  exit;
}

$data = json_decode($payload, true);
if (!is_array($data)) {
  http_response_code(400);
  echo "Invalid JSON";
  exit;
}

// Validasi minimal
$keys = ['special','grand','regular','second','third','fourth','updated_at'];
foreach ($keys as $k) {
  if (!array_key_exists($k, $data)) {
    http_response_code(400);
    echo "Missing key: $k";
    exit;
  }
}

// Encode JSON
$json = json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
if ($json === false) {
  http_response_code(500);
  echo "JSON encode error";
  exit;
}

// Tulis atomik (lock)
$fp = @fopen($RESULTS_FILE, 'c+'); // create if not exists
if (!$fp) {
  http_response_code(500);
  echo "Cannot open results.json";
  exit;
}
if (!flock($fp, LOCK_EX)) {
  fclose($fp);
  http_response_code(500);
  echo "Cannot lock file";
  exit;
}
ftruncate($fp, 0);
rewind($fp);
$bytes = fwrite($fp, $json);
fflush($fp);
flock($fp, LOCK_UN);
fclose($fp);

if ($bytes === false) {
  http_response_code(500);
  echo "Write failed";
  exit;
}

echo "OK";