<?php
// save.php
// Sederhana: terima POST 'token' dan 'payload' (JSON) → tulis ke results.json

header('Content-Type: text/plain; charset=utf-8');

// ====== KONFIGURASI ======
$SECRET_TOKEN = 'YOUR_SECRET_TOKEN'; // GANTI: samakan dengan editor.html
$RESULTS_FILE = __DIR__ . '/results.json';

// ====== CEK METHOD ======
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  http_response_code(405);
  echo "Method not allowed";
  exit;
}

// ====== CEK TOKEN ======
$token = $_POST['token'] ?? '';
if (!hash_equals($SECRET_TOKEN, $token)) {
  http_response_code(401);
  echo "Unauthorized";
  exit;
}

// ====== CEK PAYLOAD ======
$payload = $_POST['payload'] ?? '';
if (!$payload) {
  http_response_code(400);
  echo "Missing payload";
  exit;
}

$data = json_decode($payload, true);
if (!is_array($data)) {
  http_response_code(400);
  echo "Invalid JSON";
  exit;
}

// ====== VALIDASI MINIMAL ======
$keys = ['prize1','prize2','prize3','starter','consolation','updated_at'];
foreach ($keys as $k) {
  if (!array_key_exists($k, $data)) {
    http_response_code(400);
    echo "Missing key: $k";
    exit;
  }
}
if (!is_array($data['starter']) || !is_array($data['consolation'])) {
  http_response_code(400);
  echo "starter / consolation harus array";
  exit;
}
$data['starter'] = array_slice(array_map('strval', $data['starter']), 0, 5);
$data['consolation'] = array_slice(array_map('strval', $data['consolation']), 0, 5);

// ====== TULIS KE FILE ======
$json = json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
if ($json === false) {
  http_response_code(500);
  echo "Gagal encode JSON";
  exit;
}

// Lock file saat menulis untuk menghindari race condition
$fp = @fopen($RESULTS_FILE, 'c+'); // create if not exists
if (!$fp) {
  http_response_code(500);
  echo "Tidak bisa membuka results.json";
  exit;
}

if (!flock($fp, LOCK_EX)) {
  fclose($fp);
  http_response_code(500);
  echo "Gagal lock file";
  exit;
}

ftruncate($fp, 0);
rewind($fp);
$bytes = fwrite($fp, $json);
fflush($fp);
flock($fp, LOCK_UN);
fclose($fp);

if ($bytes === false) {
  http_response_code(500);
  echo "Gagal menulis file";
  exit;
}

echo "OK";